--TGA loader
-- A demo for Lua Turtle 
local f = assert(io.open("sprite32.tga", "rb"));	--Specify file you want to open (full path is required! e.g. "C:\\LuaTurtle\\examples\\sprite32.tga")
local data = f:read("*all");	--Read the complete image at once
f:close();

--First step: Parse the TGA header to ensure the file's format is supported:
--Only unmapped rgb supported
if(not (string.byte(data, 1) == 0 and string.byte(data, 2) == 0 and string.byte(data, 3) == 2) ) then
	print("Invalid data format."); return;
end
local bpp = string.byte(data, 17)
if(bpp ~= 24 and bpp ~= 32) then
	print("Only 24 bit and 32 bit images supported! "..string.byte(data, 17));
elseif(bpp == 32) then
	print("32 bit image found. Using alpha channel for transparency");
end

--Second Step: Get width, height and bpp from the header:
local width, height;
width  = string.byte(data, 13) + string.byte(data, 14)*256;
height = string.byte(data, 15) + string.byte(data, 16)*256;
local idb = string.byte(data, 18);


--Third step: Acquire image data and draw:
print("Drawing TGA, "..width.."x"..height.." pixels, "..bpp.." bpp");

turtle.PenUp();
turtle.Goto(-200, 250);
turtle.PenDown();
if(math.mod(idb, 32) == 0) then		--check truvision flag (if checked, the image is saved upside down)
	truvis = 0;
else 
	truvis = 1;
end
	for i=(truvis*(height-1)), ((1-truvis)*(height-1)), (truvis*(-1)+(1-truvis)) do		--loop over all rows
		for j=0, (width-1) do										--loop over all pixels in the current row
			local base = (i*width + j)*(bpp/8) + 19;		--base adress of the current pixel
				r = string.byte(data, base+2);
				g = string.byte(data, base+1);
				b = string.byte(data, base);				--rgb color components of the current pixel
				if(bpp == 32) then a = string.byte(data, base+3) else a = 255; end
				r = (r*a)/255; b = (b*a)/255; g = (g*a)/255;	--apply alpha transparency
				turtle.SetColor(r, g, b);						--set pixel color
				turtle.Go(1);									--draw pixel
		end
		turtle.PenUp();					--current row finished, perform 'carriage return'
		turtle.Go(-width);
		turtle.TurnRight(90);
		turtle.Go(1);
		turtle.TurnLeft(90);
		turtle.PenDown();
	end

--Done.